from PIL import Image
import os

try:
    img = Image.open("TD_chatGpt_orange_32x32.bmp")
    # Create a 16x16 version
    img16 = img.resize((16, 16), Image.Resampling.LANCZOS)
    
    # Save as ICO with both sizes
    img.save("TD_chatGpt_orange.ico", format='ICO', sizes=[(32, 32), (16, 16)])
    print("Successfully converted to TD_chatGpt_orange.ico with 32x32 and 16x16 sizes")
except Exception as e:
    print(f"Error converting image: {e}")
