/*	Scenario.cpp - Created by Giampiero Caprino

This file is part of Train Director 3

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; using exclusively version 2.
It is expressly forbidden the use of higher versions of the GNU
General Public License.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#include "Scenario.h"
#include "Itinerary.h"

Scenario    scenario;

Scenario::Scenario()
{
//        scriptsPool = new PoolAllocator(sizeof(Script));
        aspectPool = new PoolAllocator(sizeof(SignalAspect));
        exprNodePool = new PoolAllocator(sizeof(ExprNode));
        statementPool = new PoolAllocator(sizeof(Statement));
        tracksPool = new PoolAllocator(sizeof(Track));
        signalsPool = new PoolAllocator(sizeof(Signal));
        trainsPool = new PoolAllocator(sizeof(Train));
        trainStopPool = new PoolAllocator(sizeof(TrainStop));
        itineraryPool = new PoolAllocator(sizeof(Itinerary));
        trackInterpreterDataPool = new PoolAllocator(sizeof(TrackInterpreterData));
        signalInterpreterDataPool = new PoolAllocator(sizeof(SignalInterpreterData));
        trainInterpreterDataPool = new PoolAllocator(sizeof(TrainInterpreterData));
}


Scenario::~Scenario()
{
        delete statementPool;
        delete exprNodePool;
        delete aspectPool;
//        delete scriptsPool;
        delete tracksPool;
        delete signalsPool;
        delete trainsPool;
        delete trainStopPool;
        delete itineraryPool;
        delete trackInterpreterDataPool;
        delete signalInterpreterDataPool;
        delete trainInterpreterDataPool;
}


Char    *Scenario::newString(const char *str)
{
        return stringsPool.Allocate(str);
}


void    Scenario::Reset()
{
//        scriptsPool->Reset();
        aspectPool->Reset();
        exprNodePool->Reset();
        statementPool->Reset();
        tracksPool->Reset();
        trainsPool->Reset();
        trainStopPool->Reset();
        signalsPool->Reset();
        itineraryPool->Reset();
        stringsPool.Reset();
        trackInterpreterDataPool->Reset();
        signalInterpreterDataPool->Reset();
        trainInterpreterDataPool->Reset();
}
