/*	Scenario.h - Created by Giampiero Caprino

This file is part of Train Director 3

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; using exclusively version 2.
It is expressly forbidden the use of higher versions of the GNU
General Public License.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#ifndef _SCENARIO_H
#define _SCENARIO_H

#include "Traindir3.h"
#include "Allocator.h"

//      The scenario class encapsulates all information
//      needed to simulate a specific scenario, such as
//      track layout, train schedule, signal scripts etc.
//
//      Data required to run the simulator, such as windows objects
//      static icons, colors etc are not part of the scenario
//      since they are managed by the simulator as a whole.

class Scenario {
public:
        Scenario();
        virtual ~Scenario();

        void    Reset();

        Char    *newString(const Char *str);

        // schedule
        // stranded
        // layout
        // switchboards

        PoolAllocator *aspectPool;
        PoolAllocator *exprNodePool;
        PoolAllocator *statementPool;
//        PoolAllocator *scriptsPool; cannot use the pool!
        PoolAllocator *tracksPool;
        PoolAllocator *signalsPool;
        PoolAllocator *trainsPool;
        PoolAllocator *trainStopPool;
        PoolAllocator *itineraryPool;
        PoolAllocator *trackInterpreterDataPool;
        PoolAllocator *signalInterpreterDataPool;
        PoolAllocator *trainInterpreterDataPool;
        StringPool  stringsPool;
};

extern Scenario scenario;

#endif // _SCENARIO_H
