/*	ZonesDialog.cpp - Created by Giampiero Caprino

This file is part of Train Director 3

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; using exclusively version 2.
It is expressly forbidden the use of higher versions of the GNU
General Public License.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#include <wx/wxprec.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/statline.h>
#include <wx/arrstr.h>

#include "Traindir3.h"
#include "ZonesDialog.h"
#include "Canvas.h"

static	const wxChar	*names[] = {
	wxT("Ctrl+F1"),
	wxT("Ctrl+F2"),
	wxT("Ctrl+F3"),
	wxT("Ctrl+F4"),
	wxT("Ctrl+F5"),
	wxT("Ctrl+F6"),
	wxT("Ctrl+F7"),
	wxT("Ctrl+F8"),
	wxT("Ctrl+F9"),
	0
};

ZonesDialog::ZonesDialog(wxWindow *parent)
: wxDialog(parent, 0, L("Zone Definition"), wxDefaultPosition, wxDefaultSize,
	   wxDEFAULT_DIALOG_STYLE, L(" Days "))
{
	int		i;
	wxArrayString   strings;
	wxBoxSizer	*column = new wxBoxSizer( wxVERTICAL );
	wxStaticText    *header = new wxStaticText( this, 0, 
	    L("Key sequence to associate with the current layout zone?"));
    
	column->Add(header, 0, wxALIGN_LEFT | wxALL, 10);

	for(i = 0; names[i]; ++i) {
            CanvasZone *pzone = &canvasZone[i];
            wxBoxSizer	*row = new wxBoxSizer( wxHORIZONTAL );

            m_radio_buttons[i] = new wxRadioButton(this, i + 1, names[i]);
            m_names[i] = new wxTextCtrl(this, 0, pzone->name, wxDefaultPosition, wxDefaultSize);
            row->Add(m_radio_buttons[i], 1, wxGROW | wxTOP | wxRIGHT | wxLEFT, 10);
            row->Add(m_names[i], 1, wxGROW | wxTOP | wxRIGHT | wxLEFT, 10);
            column->Add(row);
	}
	column->Add(CreateButtonSizer(wxOK | wxCANCEL), 0, wxGROW | wxALL, 10);
	SetSizer(column);
	column->Fit(this);
	column->SetSizeHints(this);
}

ZonesDialog::~ZonesDialog()
{
}

int	ZonesDialog::ShowModal()
{
	Centre();
	bool oldIgnore = traindir->m_ignoreTimer;
	traindir->m_ignoreTimer = true;
	int res = wxDialog::ShowModal();
	traindir->m_ignoreTimer = oldIgnore;
        if(res != wxID_OK)
            return res;
        int zone;
        for(zone = 0; zone < 9; ++zone) {
            if(m_radio_buttons[zone]->GetValue()) {
                grid	*g = (grid *)field_grid; // TODO
                g->DefineZone(zone, m_names[zone]->GetValue());
                break;
            }
        }

//	int zone = m_radio_box->GetSelection();
//        grid	*g = (grid *)field_grid; // TODO
//        g->DefineZone(zone);
	return res;
}

