/*	MotivePower.cpp - Created by Giampiero Caprino

This file is part of Train Director 3

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; using exclusively version 2.
It is expressly forbidden the use of higher versions of the GNU
General Public License.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#include "wx/wx.h"
#include "defs.h"
#include "Version.h"

Version::Version()
{
        version = 0;
        major = 0;
        minor = 0;
}

Version::Version(int v, int M, int m)
{
        version = v;
        major = M;
        minor = m;
}

void Version::Parse(Char *p) {
        version = wxStrtoul(p, &p, 10);
        major = 0;
        minor = 0;
        if(*p == '.') {
            major = wxStrtoul(p + 1, &p, 10);
            if(*p == '.') {
                minor = wxStrtoul(p + 1, &p, 10);
            }
        }
}

bool Version::Compatible(const Version *required) {
        if(!required->version)
            return true;
        if(this->version < required->version)
            return false;
        if(!required->major)
            return true;
        if(this->major < required->major)
            return false;
        if(!required->minor)
            return true;
        if(this->minor < required->minor)
            return false;
        return true;
}
