/*	defs.h - Created by Giampiero Caprino

This file is part of Train Director 3

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; using exclusively version 2.
It is expressly forbidden the use of higher versions of the GNU
General Public License.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#include "wx/ffile.h"
#include "Html.h"
#include "Traindir3.h"
#include "trsim.h"
#include "UIwxWidgets.h"
#include "MainFrm.h"
#include "TrackDialog.h"

UIwxWidgets::UIwxWidgets(Traindir *app)
: UIClient(app)
{
	m_frame = new MainFrame(program_name);
	m_frame->SetSize(900, 600);
	m_frame->m_app = app;
}

UIwxWidgets::~UIwxWidgets()
{
}

void UIwxWidgets::Show(void)
{
	m_frame->Finalize();
	m_frame->SetIcon(wxIcon(wxT("TD_ICON")));
	m_frame->Show(true);
}

MainFrame *UIwxWidgets::GetFrame(void)
{
        return m_frame;
}

void UIwxWidgets::LoadState(Char *section, TConfig& state)
{
        m_frame->LoadState(section, state);
}

void UIwxWidgets::SaveState(Char *section, TConfig& state)
{
        m_frame->SaveState(section, state);
}

void    UIwxWidgets::ShowHtml(const Char *pageName, const wxString& content)
{
        m_frame->ShowHtml(pageName, content);
}

void    UIwxWidgets::ShowTools(bool showHide)
{
        m_frame->ShowTools(showHide);
}

void    UIwxWidgets::ShowItinerary(bool showHide)
{
        m_frame->ShowItinerary(showHide);
}

void    UIwxWidgets::ShowGraph()
{
        m_frame->ShowGraph();
}


void    UIwxWidgets::BringPageToFront(const Char *label)
{
        int	pg = m_frame->m_top->FindPage(label);
        if(pg >= 0)
	    m_frame->m_top->SetSelection(pg);
}


//
//      Dialogs
//

int UIwxWidgets::AskQuestion(const Char *msg)
{
	int	res;

	res = wxMessageBox(LV(msg), L("Question"), wxYES_DEFAULT|wxYES_NO|wxICON_QUESTION, m_frame);
	if(res == wxYES)
	    return ANSWER_YES;
	return ANSWER_NO;
}

void    UIwxWidgets::ShowErrorBox(const char *error_msg)
{
	wxMessageBox(error_msg, wxT("Error"), wxOK|wxICON_ERROR, m_frame);
}


void    UIwxWidgets::ShowTrackProperties(Track *trk)
{
	TrackDialog diag(m_frame, trk);

	diag.ShowModal(trk);
}

