#ifndef _TVECTOR_H
#define _TVECTOR_H

class Track;
enum CompassDir;

struct Vector {
	int	_size;
	int	_maxelem;
	TrackBase **_ptr;
	char	*_flags;		// direction of this track (DEPRECATED)
        CompassDir *_directions;        // direction out of this track
	long	_pathlen;		// length in meters of this path

        Vector  *_nextFree;

        Vector(int hint = 0);
        ~Vector();

	Track	*TrackAt(int index);	// get object at index
        Track   *FirstTrack();
        Track   *LastTrack();
	int	FlagAt(int index);
        CompassDir DirectionAt(int index);
	void	Empty();
	void	Add(TrackBase *trk, int flag, CompassDir dir);
	void	Add(TrackBase *trk, int flag);
	void	DeleteAt(int index);
	void	DeleteTrack(TrackBase *trk);
	int	Find(TrackBase *trk);
	void	Reverse();
	void	Insert(TrackBase *trk, int f, CompassDir dir);// insert new element at the beginning
	void	Insert(Vector *newPath);// insert new path at the beginning
	void	ComputeLength();	// length in meters of path
};

#endif // _TVECTOR_H
