/*	HeadlessClient.cpp - Created by Giampiero Caprino

This file is part of Train Director 3

Train Director is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; using exclusively version 2.
It is expressly forbidden the use of higher versions of the GNU
General Public License.

Train Director is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Train Director; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

#include "wx/ffile.h"
#include "Html.h"
#include "Traindir3.h"
#include "trsim.h"
#include "NoUIClient.h"
#include "Canvas.h"

HeadlessClient::HeadlessClient(Traindir *app)
: UIClient(app)
{
	grid *g;

	g = new grid(0, XMAX * 2, YMAX * 2);
	g->m_hmult = HGRID;
	g->m_vmult = VGRID;
	field_grid = g;
	current_grid = g;
//	set_show_coord(true);
}


HeadlessClient::~HeadlessClient()
{
}

void HeadlessClient::LoadState(Char *section, TConfig& state)
{
}


void HeadlessClient::SaveState(Char *section, TConfig& state)
{
}


int HeadlessClient::AskQuestion(const Char *msg)
{
        return ANSWER_YES;
}

